<?php
/**
 * Generated by the WordPress Option Page generator
 * at http://jeremyhixon.com/wp-tools/option-page/
 */

class SellersjsonOptions {
  private $sellers_json_options_options;

  public function __construct() {
    add_action( 'admin_menu', array( $this, 'sellers_json_options_add_plugin_page' ) );
    add_action( 'admin_init', array( $this, 'sellers_json_options_page_init' ) );
  }

  public function sellers_json_options_add_plugin_page() {
    add_submenu_page(
      'edit.php?post_type=seller',
      'Sellers.json Options',
      'Options',
      'manage_options',
      'sellers-json-options',
       array( $this, 'sellers_json_options_create_admin_page' )
    );
  }

  public function sellers_json_options_create_admin_page() {
    $this->sellers_json_options_options = get_option( 'sellers_json_options_option_name' ); ?>

    <div class="wrap">
      <h2>Sellers.json Options</h2>
      <p>Define the global properties that apply to your entire sellers.json file.</p>
      <?php settings_errors(); ?>

      <form method="post" action="options.php">
        <?php
          settings_fields( 'sellers_json_options_option_group' );
          do_settings_sections( 'sellers-json-options-admin' );
          submit_button();
        ?>
      </form>
    </div>
  <?php }

  public function sellers_json_options_page_init() {
    register_setting(
      'sellers_json_options_option_group', // option_group
      'sellers_json_options_option_name', // option_name
      array( $this, 'sellers_json_options_sanitize' ) // sanitize_callback
    );

    add_settings_section(
      'sellers_json_options_setting_section', // id
      'Settings', // title
      array( $this, 'sellers_json_options_section_info' ), // callback
      'sellers-json-options-admin' // page
    );

    add_settings_field(
      'contact_email_0', // id
      'Contact Email', // title
      array( $this, 'contact_email_0_callback' ), // callback
      'sellers-json-options-admin', // page
      'sellers_json_options_setting_section' // section
    );

    add_settings_field(
      'contact_address_1', // id
      'Contact Address', // title
      array( $this, 'contact_address_1_callback' ), // callback
      'sellers-json-options-admin', // page
      'sellers_json_options_setting_section' // section
    );
  }

  public function sellers_json_options_sanitize($input) {
    $sanitary_values = array();
    if ( isset( $input['contact_email_0'] ) ) {
      $sanitary_values['contact_email_0'] = sanitize_text_field( $input['contact_email_0'] );
    }

    if ( isset( $input['contact_address_1'] ) ) {
      $sanitary_values['contact_address_1'] = sanitize_text_field( $input['contact_address_1'] );
    }

    return $sanitary_values;
  }

  public function sellers_json_options_section_info() {

  }

  public function contact_email_0_callback() {
    printf(
      '<input class="regular-text" type="text" name="sellers_json_options_option_name[contact_email_0]" id="contact_email_0" value="%s">',
      isset( $this->sellers_json_options_options['contact_email_0'] ) ? esc_attr( $this->sellers_json_options_options['contact_email_0']) : ''
    );
    echo ' <span class="description">An email address to use to contact the Advertising System for questions or inquiries about your sellers.json.</span>';
  }

  public function contact_address_1_callback() {
    printf(
      '<input class="regular-text" type="text" name="sellers_json_options_option_name[contact_address_1]" id="contact_address_1" value="%s">',
      isset( $this->sellers_json_options_options['contact_address_1'] ) ? esc_attr( $this->sellers_json_options_options['contact_address_1']) : ''
    );
    echo ' <span class="description">The business address of the advertising system.</span>';
  }

}
if ( is_admin() )
  $sellers_json_options = new SellersjsonOptions();

/*
 * Retrieve this value with:
 * $sellers_json_options_options = get_option( 'sellers_json_options_option_name' ); // Array of All Options
 * $contact_email_0 = $sellers_json_options_options['contact_email_0']; // Contact Email
 * $contact_address_1 = $sellers_json_options_options['contact_address_1']; // Contact Address
 */
